#!/usr/bin/perl

if ($#ARGV < 0) {
        print STDERR "usage: $0 <pdbfile> \n";
        exit -1;
}

print "<table> <tr><td><font face='Arial, Helvetica, Sans-serif' size=2><b>Less </b></font></td>\n";
print "<td bgcolor=#0000cc><font face='Bold, Times-Roman',size=2><40</font></td>\n";
print "<td bgcolor=#00cccc><font face='Bold, Times-Roman',size=2>40-50</font></td>\n";
print "<td bgcolor=#009900><font face='Bold, Times-Roman',size=2>50-60</font></td>\n";
print "<td bgcolor=#99ff00><font face='Bold, Times-Roman',size=2>60-70</font></td>\n";
print "<td bgcolor=#ccff00><font face='Bold, Times-Roman',size=2>70-80</font></td>\n";
print "<td bgcolor=#cc6600><font face='Bold, Times-Roman',size=2>80-90</font></td>\n";
print "<td bgcolor=#cc0000><font face='Bold, Times-Roman',size=2>>90</font></td>\n";
print "<td><font face='Arial, Helvetica, Sans-serif' size=2><b>More </b></font></td></tr></table>\n";


$pdbfile=$ARGV[0];

@residues=`grep ^ATOM $pdbfile | cut -c 18-27,61-66 |uniq`; # format: ASP B  86

chomp(@residues);

#title for the sequence
$ch_first=substr($residues[0],4,1); # first chain in the file

$pdbf = `basename $pdbfile`; 
chomp($pdbf); 
$pdbf =substr($pdbf,0,4);

$ch_suf=substr($pdbfile,17,2);

print "<table> <tr>\n ";
for $r (@residues) {
    $three = substr($r,0,3); #res. name
    $ch = substr($r,4,1); # chain
    $n = substr($r,5,4); # res. number
    $bf = substr($r,10,5); # res. number

    #start a new chain
    if ($last_ch ne $ch) {
	$name = '>Chain:'.$ch;		
        print "</tr> </table>\n ";
        print "\n$name\n";
        print "<table> <tr>\n ";
    }

    $one = &one_from_three($three);

    
    if($bf < 40) {
       $color="0000cc";
    } elsif($bf < 50) {
       $color="00cccc";
    } elsif($bf < 60) {
       $color="009900";
    } elsif($bf < 70) {
       $color="99ff00";
    } elsif($bf < 80) {
       $color="ccff00";
    } elsif($bf < 90) {
       $color="cc6600";
    } else  {
       $color="cc0000";
    }

    print "<td align=center bgcolor=$color><font face='Arial, Helvetica, Sans-serif'  size=2><b>";
    print $one, "</b></font></td>\n";
    $last_ch = $ch;
}
print "</tr> </table>\n ";
     




sub one_from_three {
    local $three = shift;
    $one='X';
    $one="A" if ($three eq "ALA");
    $one="C" if ($three eq "CYS");
    $one="D" if ($three eq "ASP");
    $one="E" if ($three eq "GLU");
    $one="F" if ($three eq "PHE");
    $one="G" if ($three eq "GLY");
    $one="H" if ($three eq "HIS");
    $one="I" if ($three eq "ILE");
    $one="K" if ($three eq "LYS");
    $one="L" if ($three eq "LEU");
    $one="M" if ($three eq "MET");
    $one="N" if ($three eq "ASN");
    $one="P" if ($three eq "PRO");
    $one="Q" if ($three eq "GLN");
    $one="R" if ($three eq "ARG");
    $one="S" if ($three eq "SER");
    $one="T" if ($three eq "THR");
    $one="V" if ($three eq "VAL");
    $one="W" if ($three eq "TRP");
    $one="Y" if ($three eq "TYR");
    return $one;
}
